//
//  LoginViewController.m
//  ABC Bank
//
//  Created by davesm on 10/14/13.
//  Copyright (c) 2013 Cisco Systems, Inc. All rights reserved.
//

#import "LoginViewController.h"
#import "Gradient.h"
#import <JabberGuest/JabberGuest.h>

@interface LoginViewController ()

@end

@implementation LoginViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    NSUserDefaults *sud = [NSUserDefaults standardUserDefaults];
    [sud registerDefaults:[NSDictionary dictionaryWithObjectsAndKeys:
                           @"5555", @"username",
                           @"jabberguestsandbox.cisco.com", @"password",
                           nil]];
    
    self.username.text = [sud objectForKey:@"username"];
    self.password.text = [sud objectForKey:@"password"];
    
    [self decorateBackground:self.lowerView];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBarHidden = NO;
}

- (void)decorateBackground:(UIView *)view

{
    UIColor * backgroundTop = [UIColor colorWithRed:(CGFloat)0x00 / 0xff green:(CGFloat)0xc6 / 0xff blue:(CGFloat)0x5b / 0xff alpha:1.0f];
    
    UIColor * backgroundBottom = [UIColor colorWithRed:(CGFloat)0x00 / 0xff green:(CGFloat)0x93 / 0xff blue:(CGFloat)0x45 / 0xff alpha:1.0f];
    
    [Gradient applyBackgroundGradient:view
                         topColor:backgroundTop
                      bottomColor:backgroundBottom];
    
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    NSUserDefaults *sud = [NSUserDefaults standardUserDefaults];
    
    if ( textField == self.username ) {
        [sud setObject:self.username.text forKey:@"username"];
        [self.password becomeFirstResponder];
    }
    else if ( textField == self.password ) {
        [sud setObject:self.password.text forKey:@"password"];
        [textField resignFirstResponder];
    }
    
    return NO;
}

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    [CJGuestCall sharedInstance].toURI = self.username.text;
    [CJGuestCall sharedInstance].serverName = self.password.text;
}

@end
